import java.net.*;

import java.io.*;

/**
 * <p>ComBlock_java_API</p>
 *
 * <p>Description: periodically establishes a TCP connection with one ComBlock module
 * and asks for its status. Log the status in file with a timestamp.</p>
 *
 * <p>Copyright: Copyright (c) 2016</p>
 *
 * @author not attributable
 * @version 1.0
 */
public class Main {
    private InetAddress destIP = null;
    private int destPort = 1028;	// ComBlock M&C port
    private int testRepetitionPeriod = 30; 	// test repetition period in ms
    private InetSocketAddress destSocketAddress = null;
    private Socket clientSocket = null;
    private BufferedInputStream TCPIPinputStream = null;
    private DataOutputStream outToServer = null;
    private BufferedReader inFromServer = null;
    byte[] outBuf = new byte[4096];
    byte[] inBuf = new byte[4096];
    String response;
    int nqueries, nresponses, nerr1, nerr2, nerr3 = 0;
        public Main() {
    	// open output file
        FileOutputStream fileOut = null;
        try {
            fileOut = new FileOutputStream("C:\\Users\\Alain\\Documents\\source_Java\\1705b.stn");
        } catch (FileNotFoundException ex1) {
        }
		try {
			destIP = InetAddress.getByAddress(new byte[] {(byte) 172, 16, 1,
			        (byte) 128}); // ComBlock IP address
			destSocketAddress = new InetSocketAddress(destIP, destPort);
		} catch (UnknownHostException e1) {
			// TODO Auto-generated catch block
			e1.printStackTrace();
		}
        
        // every n seconds open connection, get status, log it, close connection, repeat
        for(int i=0; i<10000; i++){
        	nqueries++;
			try {
				clientSocket = new Socket();
				try {
					clientSocket.connect(destSocketAddress, 1000); // blocking
				} catch (Exception e1) {
					// very likely the server connection is not fully released yet. Wait a bit more.
					nerr3++;
					try {
						Thread.sleep(1000);	// in ms 
					} catch (Exception e) {
					}
					continue;
				}

				outToServer = new DataOutputStream(clientSocket.getOutputStream());
				inFromServer = new BufferedReader(new InputStreamReader(clientSocket.getInputStream()));
				TCPIPinputStream = new BufferedInputStream(clientSocket.
				        getInputStream(), 4096);

				outToServer.writeBytes("@000SAC001\r\n");
				try {
					Thread.sleep(5);	// 5ms between successive commands with no response
				} catch (Exception e) {
				}
				//outToServer.writeBytes("@001GMI\r\n");			// 
				outToServer.writeBytes("@001GMS020000\r\n");	// get multiple (32) status registers
				try {
					Thread.sleep(5);	// 5ms between successive commands with no response
				} catch (Exception e) {
				}
				response = inFromServer.readLine();
				if(response.length() != 0){
					nresponses++;
				}
				System.out.println(response+"  "+nqueries+"  "+nresponses+"  "+nerr1+"  "+nerr2+"  "+nerr3);
				try {
					Thread.sleep(10);
				} catch (Exception e) {
				}
				outToServer.close();
				TCPIPinputStream.close();
				clientSocket.close();
			} catch (UnknownHostException e) {
				nerr1++;
				e.printStackTrace();
			} catch (IOException e) {
				nerr2++;
				e.printStackTrace();
			}

			// wait TBD second, then repeat process
			try {
				Thread.sleep(testRepetitionPeriod);	// 5ms between successive commands with no response
			} catch (Exception e) {
			}
        }
        // don't forget to close log file
		try {
			fileOut.close();
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
        
    }

    public static void main(String[] args) {
        Main main = new Main();
    }
}
